/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.HardwareAnalysis;
import com.ibm.hwmca.base.pa.ar.HardwareEvent15Rule;
import com.ibm.hwmca.base.pa.ar.HardwareEvent15RuleBase;
import com.ibm.hwmca.base.pa.ar.HardwareEvent15XMLParser;
import com.ibm.hwmca.base.pa.event.HardwareDataEventClass15;
import com.ibm.hwmca.base.pa.event.HardwareFailuresClass04;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Calendar;

public class HardwareAnalysisClass15
extends HardwareAnalysis
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPAH15AT";
    private static final String TRACE_MASKF = "XPAH15AF";
    private static final String TRACE_MASKD = "XPAH15AD";
    private Calendar currentCalendar = Calendar.getInstance(UserContext.getCurrentUserContext().getTimeZone(), UserContext.getCurrentUserContext().getLocale());

    public HardwareAnalysisClass15() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> analyze()");
        super.analyze(event);
        HardwareDataEventClass15 ourEvent = (HardwareDataEventClass15)event;
        this.getProblem().setCategory(1);
        this.getProblem().setDescription(1637);
        this.getProblem().setTransmit(true);
        String baseFilePath = HardwareAnalysisClass15.getBaseFilePath("paconfig");
        String XMLFileToUse = baseFilePath + "IQYP3315.XML";
        HardwareEvent15RuleBase rb = null;
        try {
            rb = HardwareEvent15XMLParser.parseXML(XMLFileToUse);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Exception parsing file");
        }
        if (rb == null) {
            Trace.trace(TRACE_MASKD, ": ADEPT did not return rules base");
            new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis15"), HardwareFailuresClass04.XP33_0D_ADEPT_CALL_ERR).log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        HardwareEvent15Rule rule = rb.findRule(ourEvent.getPahRfCod());
        if (rule == null) {
            Trace.trace(TRACE_MASKD, ": ADEPT returned NULL refcode.");
            new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis15"), 5380).log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        if (rule.getService().equals("")) {
            Trace.trace(TRACE_MASKD, ": ADEPT returned NULL service");
            new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis15"), 7).log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        this.problem.setService(rule.getService());
        if (rule.getPriority().equals("")) {
            Trace.trace(TRACE_MASKD, ": ADEPT returned NULL panel_priority.");
            new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis15"), 5).log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        this.incident.setPriority(rule.getPriorityAsFloat());
        if (rule.getMessages() == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 4, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        ArrayList messages = rule.getMessageList();
        Trace.trace(TRACE_MASKT, "all of our messages ");
        for (int i = 0; i < messages.size(); ++i) {
            Trace.trace(TRACE_MASKT, "index=" + i + " value =" + messages.get(i));
        }
        HardwareAnalysisClass15.setMessages(this.getProblem(), messages);
        if (this.getProblem().getRefcode().equals("75110200")) {
            boolean sim_value = false;
            if ("rc from test" == null) {
                Trace.trace(TRACE_MASKT, "<-- analyze()");
                return;
            }
            if (sim_value) {
                Trace.trace(TRACE_MASKF, ": Model conversion 75110200, no error");
                this.getProblem().setService("N");
            }
        }
        this.finishAndReport(ourEvent, this.problem, this.incident);
        Trace.trace(TRACE_MASKD, "<-- analyze");
    }
}

